(
	-- Bitmap Texture

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"b4321acb-05bf-449c-95f9-4b24240ade4f"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			append res #("UV", mtl.coords) -- UVGenerator
			append res #("utangent", mtl.coords, "utangent") 
			append res #("vtangent", mtl.coords, "vtangent") 
			append res #("visible",  mtl.coords, "visible") 

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #( "rgb_source",		    mtl.rgbOutput == 1 )  
			append res #( "mono_source",		mtl.monoOutput == 1 )  
			append res #( "alpha_source",		mtl.alphaSource == 1 )  
			append res #( "output_alpha",		mtl.alphaSource < 2 )  
			
			append res #( "apply",				mtl.apply)  
			append res #( "place",				mtl.cropPlace == 1)  
			append res #( "u",					mtl.ClipU)  
			append res #( "v",					mtl.ClipV)  
			append res #( "w",					mtl.ClipW)  
			append res #( "h",					mtl.ClipH)  
			append res #( "random",				mtl.useJitter)  
			append res #( "jitter",				mtl.Jitter)  

			append res #("Bitmap", mtl, "bitmap")

			-- Output parameters
			append res #( "invert",			mtl.output.invert)                   
			append res #( "clamp",			mtl.output.clamp )  
			append res #( "rgb_level",		mtl.output.RGB_Level )  
			append res #( "rgb_offset",		mtl.output.RGB_Offset )  
			append res #( "out_amount",		mtl.output.Output_Amount )  
			append res #( "bump_amount",	mtl.output.Bump_Amount)  
			append res #( "alpha_from_rgb",	mtl.output.alphaFromRGB)  
			append res #( "curves",			mtl,   "output" )  -- Attach and translate the "output" rollout

 			res
		)
	)

	AMGData()
)